// 保存した範囲を管理
let savedRanges = [];

function highlightRange(range) {
  const span = document.createElement("span");
  span.style.backgroundColor = "yellow";
  span.classList.add("multi-select-highlight");

  try {
    // 選択範囲を span で囲う
    range.surroundContents(span);
  } catch (e) {
    console.warn("複雑な DOM 構造で囲めない部分があります:", e);
  }
}

document.addEventListener("mouseup", () => {
  const sel = window.getSelection();
  if (!sel.rangeCount) return;

  const range = sel.getRangeAt(0).cloneRange();

  // 選択文字が空なら無視
  if (range.toString().trim() === "") return;

  // 保存
  savedRanges.push(range);

  // 見た目の選択を一旦解除
  sel.removeAllRanges();

  // ハイライトを付ける
  highlightRange(range);
});
