const clickEffect = document.getElementById("clickEffect");
const copyNotify = document.getElementById("copyNotify");

// 現在の設定を読み込み
chrome.storage.sync.get(["clickEffect", "copyNotify"], (data) => {
  clickEffect.checked = data.clickEffect ?? true;
  copyNotify.checked = data.copyNotify ?? true;
});

// 変更時に保存
clickEffect.addEventListener("change", () => {
  chrome.storage.sync.set({ clickEffect: clickEffect.checked });
});
copyNotify.addEventListener("change", () => {
  chrome.storage.sync.set({ copyNotify: copyNotify.checked });
});