let clickEnabled = true;
let copyEnabled = true;

// 設定を読み込み
chrome.storage.sync.get(["clickEffect", "copyNotify"], (data) => {
  clickEnabled = data.clickEffect ?? true;
  copyEnabled = data.copyNotify ?? true;
});

// 設定変更を監視
chrome.storage.onChanged.addListener((changes) => {
  if (changes.clickEffect) clickEnabled = changes.clickEffect.newValue;
  if (changes.copyNotify) copyEnabled = changes.copyNotify.newValue;
});

// --- クリックエフェクト ---
document.addEventListener("mousedown", (e) => {
  if (!clickEnabled) return;

  const circle = document.createElement("div");
  Object.assign(circle.style, {
    position: "fixed",
    left: e.clientX - 50 + "px",
    top: e.clientY - 50 + "px",
    width: "100px",
    height: "100px",
    borderRadius: "50%",
    background: "rgba(0,150,255,0.3)",
    transform: "scale(0)",
    transition: "transform 0.3s ease-out, opacity 0.6s ease-out",
    pointerEvents: "none",
    zIndex: 999999,
  });
  document.body.appendChild(circle);
  requestAnimationFrame(() => (circle.style.transform = "scale(1)"));
  setTimeout(() => (circle.style.opacity = "0"), 300);
  setTimeout(() => circle.remove(), 900);
});

// --- コピー通知 ---
document.addEventListener("copy", (e) => {
  if (!copyEnabled) return;

  let text = "";
  try {
    text = document.getSelection().toString() || e.clipboardData?.getData("text/plain");
  } catch {}

  if (!text) return;

  const popup = document.createElement("div");
  popup.textContent = `📋 コピー: ${text}`;
//  popup.textContent = `📋 コピー: ${text.length > 50 ? text.slice(0, 50) + "..." : text}`; 
  Object.assign(popup.style, {
    position: "fixed",
    bottom: "20px",
    right: "20px",
    background: "rgba(0,0,0,0.7)",
    color: "#fff",
    padding: "8px 12px",
    borderRadius: "8px",
    fontSize: "14px",
    zIndex: 999999,
    opacity: "1",
    transition: "opacity 0.5s",
  });
  document.body.appendChild(popup);
  setTimeout(() => (popup.style.opacity = "0"), 2000);
  setTimeout(() => popup.remove(), 2500);
});



Object.assign(popup.style, {
  position: "fixed",
  bottom: "20px",
  right: "20px",
  background: "rgba(0,0,0,0.7)",
  color: "#fff",
  padding: "8px 12px",
  borderRadius: "8px",
  fontSize: "14px",
  zIndex: 999999,
  opacity: "1",
  transition: "opacity 0.5s",
  maxWidth: "50vw",         // ← 横幅制限
  whiteSpace: "pre-wrap",   // ← 折り返し許可
  wordBreak: "break-all",   // ← 長い英単語も折り返し
});
