const btn = document.getElementById('toggle');

chrome.storage.local.get('enabled', data => {
  const enabled = data.enabled ?? true;
  updateButton(enabled);
});

btn.addEventListener('click', () => {
  chrome.storage.local.get('enabled', data => {
    const newVal = !data.enabled;
    chrome.storage.local.set({ enabled: newVal });
    updateButton(newVal);
  });
});

function updateButton(on) {
  btn.textContent = on ? 'ON（有効）' : 'OFF（無効）';
  btn.className = on ? 'on' : 'off';
}
