let enabled = true;
chrome.storage.local.get('enabled', data => enabled = data.enabled);

chrome.storage.onChanged.addListener(changes => {
  if (changes.enabled) enabled = changes.enabled.newValue;
});

let circle = null;

document.addEventListener('mousedown', e => {
  if (!enabled) return;

  circle = document.createElement('div');
  const sizePx = 40; // 初期サイズ（約1cm）
  circle.style.width = sizePx + 'px';
  circle.style.height = sizePx + 'px';
  circle.style.borderRadius = '50%';
  circle.style.background = 'rgba(0, 150, 255, 0.3)';
  circle.style.position = 'absolute';
  circle.style.pointerEvents = 'none';
  circle.style.left = (e.pageX - sizePx / 2) + 'px';
  circle.style.top = (e.pageY - sizePx / 2) + 'px';
  circle.style.transition = 'transform 0.4s ease-out, opacity 0.3s ease-out';
  document.body.appendChild(circle);

  requestAnimationFrame(() => {
    circle.style.transform = 'scale(2)'; // 拡大→約2cm相当
  });
});

document.addEventListener('mouseup', () => {
  if (!circle) return;
  circle.style.opacity = '0';
  setTimeout(() => {
    if (circle && circle.parentNode) circle.parentNode.removeChild(circle);
    circle = null;
  }, 300);
});
