chrome.runtime.sendMessage({ greeting: "hello" }, function(response) {
  if (chrome.runtime.lastError) {
    console.warn("Message failed:", chrome.runtime.lastError.message);
  } else {
    console.log("Response:", response);
  }
});

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg.action === "openTab" && msg.url) {
    chrome.tabs.create({ url: msg.url });
  }
});

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg.action === "openInBackgroundTab" && msg.url) {
    chrome.tabs.create({
      url: msg.url,
      active: false  // ✅ バックグラウンドで開く
    });
  }
});
