document.getElementById("searchBtn").addEventListener("click", () => {
  const keyword = document.getElementById("keyword").value.trim();
  const intitle = document.getElementById("intitle").value.trim();
  const exclude = document.getElementById("exclude").value.trim();

  // ラジオボタンの値取得
  const duration = document.querySelector('input[name="duration"]:checked')?.value || "";
  const period = document.querySelector('input[name="period"]:checked')?.value || "";

  let query = keyword;

  if (intitle) {
    query += ` intitle:${intitle}`;
  }

  if (exclude) {
    exclude.split(/\s+/).forEach(word => {
      query += ` -${word}`;
    });
  }

  const tbsParams = [];
  if (duration) {
    tbsParams.push(`dur:${duration}`);
  }
  if (period) {
    tbsParams.push(`qdr:${period}`);
  }

  let url = `https://www.google.com/search?q=${encodeURIComponent(query)}&tbm=vid`;
  if (tbsParams.length > 0) {
    url += `&tbs=${tbsParams.join(',')}`;
  }

  chrome.tabs.create({ url: url, active: false });
});
