function forceLoadLazyImages() {
  document.querySelectorAll('img').forEach(img => {
    // 1. src が空 or プレースホルダなら、data-* 属性から設定
    if (!img.src || img.src.includes('placeholder') || img.src.startsWith('data:')) {
      for (const key in img.dataset) {
        if (key.includes('src') && img.dataset[key]) {
          img.src = img.dataset[key];
          break;
        }
      }
    }

    // 2. srcset 対応（Instagram や Amazon）
    if (img.dataset.srcset && !img.srcset) {
      img.srcset = img.dataset.srcset;
    }

    // 3. decoding 属性などで読み込みを遅延させている場合 → eager に変更
    if (img.decoding === 'async') {
      img.decoding = 'auto';
    }

    // 4. loading="lazy" → eager に変更
    if (img.loading === 'lazy') {
      img.loading = 'eager';
    }
  });
}

setTimeout(() => {
  forceLoadLazyImages();
}, 1000);

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'getImages') {
    const images = new Set();

    // <img> タグ
    document.querySelectorAll('img').forEach(img => {
      try {
        const rect = img.getBoundingClientRect();
        if (rect.width >= 50 && rect.height >= 50 && img.src) {
          images.add(img.currentSrc || img.src);
        }
      } catch (e) {}
    });

    // background-image
    document.querySelectorAll('*').forEach(el => {
      try {
        const style = getComputedStyle(el);
        const bg = style.backgroundImage;
        const rect = el.getBoundingClientRect();

        if (bg && bg.startsWith('url(') && rect.width >= 50 && rect.height >= 50) {
          const urlMatch = bg.match(/url\(["']?(.*?)["']?\)/);
          if (urlMatch && urlMatch[1]) {
            images.add(urlMatch[1]);
          }
        }
      } catch (e) {}
    });

    sendResponse(Array.from(images));
  }
});

let hoveredImage = null;

document.addEventListener('mouseover', e => {
  if (e.target.tagName === 'IMG') {
    hoveredImage = e.target;
  }
});
document.addEventListener('mouseout', e => {
  if (e.target === hoveredImage) {
    hoveredImage = null;
  }
});

document.addEventListener('keydown', e => {
  if (!hoveredImage || e.ctrlKey || e.altKey || e.metaKey) return;

  const img = hoveredImage;
  let finalUrl = img.currentSrc || img.src;
  let filename = finalUrl.split('/').pop().split('?')[0];

  try {
    const urlObj = new URL(finalUrl);
    if (urlObj.hostname.includes('pbs.twimg.com')) {
      const id = urlObj.pathname.split('/').pop();
      let format = urlObj.searchParams.get('format') || 'jpg';
      if (format.toLowerCase() === 'jfif') format = 'jpg';
      finalUrl = `https://pbs.twimg.com/media/${id}?format=${format}&name=orig`;
      filename = `${id}.${format}`;
    } else if (urlObj.hostname.includes('pximg.net') && finalUrl.includes('/img-master/')) {
      finalUrl = finalUrl.replace('/img-master/', '/img-original/')
                         .replace(/_master\d+\.(jpg|png|webp)/, '.$1');
      filename = finalUrl.split('/').pop().split('?')[0];
    }
        else if (urlObj.hostname.includes('ytimg.com') && /\/vi\/[^/]+\/(hqdefault|mqdefault|sddefault)\.jpg/.test(urlObj.pathname)) {
      const videoId = urlObj.pathname.split('/')[2];
      finalUrl = `https://i.ytimg.com/vi/${videoId}/maxresdefault.jpg`;
      filename = `${videoId}_maxres.jpg`;
    }
  } catch (e) {
    console.warn('URL parsing failed:', e);
  }


if (e.key === 's') {
  chrome.runtime.sendMessage({
    action: 'openInBackgroundTab',
    url: finalUrl
  });
}

  if (e.key === 'd') {
    const a = document.createElement('a');
    a.href = finalUrl;
    a.download = filename;
    a.click();
  }
});