(function () {
  function applyMinimalYouTube() {
    const player = document.querySelector('ytd-player');
    if (!player) {
      setTimeout(applyMinimalYouTube, 5000);
      return;
    }

    // 不要な要素だけ明示的に非表示にする
    const selectorsToHide = [
      'ytd-watch-next-secondary-results-renderer', // 右の関連動画
      '#comments',                                 // コメント欄
      '#masthead-container',                       // ヘッダー
      'ytd-video-owner-renderer',                  // チャンネル情報
      'ytd-video-secondary-info-renderer',         // タイトルや下部
      '#info', '#meta', '#below'                   // その他下部UI
    ];

    selectorsToHide.forEach(sel => {
      const el = document.querySelector(sel);
      if (el) el.style.display = 'none';
    });

    // プレイヤーを中央に配置
    const style = document.createElement('style');
    style.textContent = `
      html, body {
        margin: 0;
        padding: 0;
        background-color: black !important;
        overflow: hidden;
      }

      ytd-app {
        background-color: black !important;
      }

      ytd-player {
        max-width: 100% !important;
        max-height: 100% !important;
        background-color: black;
      }
    `;
    document.head.appendChild(style);
  }

  applyMinimalYouTube();
})();
