chrome.action.onClicked.addListener(async (tab) => {
  // アクティブなタブの中で、YouTubeプレーヤーを探してPiP化
  chrome.scripting.executeScript({
    target: { tabId: tab.id },
    func: async () => {
      const video = document.querySelector("video");
      if (video) {
        try {
          await video.requestPictureInPicture();
        } catch (err) {
          alert("PiPモードにできませんでした");
        }
      } else {
        alert("動画が見つかりませんでした");
      }
    }
  });
});
