chrome.tabs.onRemoved.addListener(async (tabId, removeInfo) => {
  if (removeInfo.isWindowClosing) return;

  const tabs = await chrome.tabs.query({ windowId: removeInfo.windowId });

  if (tabs.length === 1) {
    // 最後の1枚になりそう → ピン留めのダミータブを作成
    chrome.tabs.create({
      url: "chrome://newtab",
      pinned: true,
      active: false,
      windowId: removeInfo.windowId
    });
  }
});
